/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp;

import DE.siemens.ad.logo.app.comp.BorderJPanel;
import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.app.comp.EditableNumericSpinner;
import DE.siemens.ad.logo.app.comp.NumericSpinnerListener;
import DE.siemens.ad.logo.dialog.comp.SpinnerChangedEvent;
import DE.siemens.ad.logo.model.PropertiesIfc;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.logo.util.ProgramException;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.LineBorder;

public class DrawingDimensionPanel
extends DataInputPanel
implements NumericSpinnerListener {
    private PropertiesIfc fModel;
    private JLabel ivjLabelHorizontal = null;
    private JLabel ivjLabelVertical = null;
    private EditableNumericSpinner ivjPagesHorizontal = null;
    private EditableNumericSpinner ivjPagesVertical = null;
    private BorderJPanel ivjPreviewPanel = null;
    private JPanel ivjPagesPanel = null;
    private int fOldNrOfPages = 0;
    private Dimension fPageDimension = null;
    private JPanel ivjPreviewBackgroundPanel = null;
    private LogoDrawing fDrawing = null;
    private JCheckBox ivjDefault = null;

    public DrawingDimensionPanel() {
        this.initialize();
    }

    public DrawingDimensionPanel(LogoDrawing logoDrawing) {
        this.fDrawing = logoDrawing;
        this.fModel = logoDrawing.getWiringDiagram().getDrawingProperties();
        this.setPageDimension(this.fDrawing.getPageDimension());
        this.initialize();
    }

    public boolean checkChanged() {
        return this.fModel.getPagesHorizontal() != this.getPagesHorizontal().getValue() || this.fModel.getPagesVertical() != this.getPagesVertical().getValue() || this.getDefault().isSelected();
    }

    public boolean checkFieldContents() {
        boolean result = this.checkFieldContents(true);
        if (result) {
            Dimension pageSize = this.fDrawing.getPageDimension();
            Dimension newSize = new Dimension(pageSize.width * this.getPagesHorizontal().getValue(), pageSize.height * this.getPagesVertical().getValue());
            Dimension minSize = this.fDrawing.getMinimumSize();
            if (newSize.width < minSize.width || newSize.height < minSize.height) {
                Object[] pageCount = new Object[]{new Integer(minSize.width / pageSize.width + 1), new Integer(minSize.height / pageSize.height + 1)};
                new LogoError(null, Language.getString("error.dialog.tooLessPages", "Too less pages to see whole drawing. You need at least % horizontal and % vertical.", pageCount)).display();
                return false;
            }
        }
        return result;
    }

    private boolean checkFieldContents(boolean userInfo) {
        int ver;
        int hor = this.getPagesHorizontal().getValue();
        if (hor * (ver = this.getPagesVertical().getValue()) > 100 || hor * ver <= 0) {
            if (userInfo) {
                LogoError dlg = new LogoError(this.getParent(), "error.dialog.tooMuchPages", "For the total number of pages (horizontal x vertical)\nonly values from 1 to 100 are valid.", 2);
                dlg.display();
            }
            return false;
        }
        return true;
    }

    private JCheckBox getDefault() {
        if (this.ivjDefault == null) {
            try {
                this.ivjDefault = new JCheckBox();
                this.ivjDefault.setName("Default");
                this.ivjDefault.setText("Default");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjDefault;
    }

    private JLabel getLabelHorizontal() {
        if (this.ivjLabelHorizontal == null) {
            try {
                this.ivjLabelHorizontal = new JLabel();
                this.ivjLabelHorizontal.setName("LabelHorizontal");
                this.ivjLabelHorizontal.setText("Hor");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLabelHorizontal;
    }

    private JLabel getLabelVertical() {
        if (this.ivjLabelVertical == null) {
            try {
                this.ivjLabelVertical = new JLabel();
                this.ivjLabelVertical.setName("LabelVertical");
                this.ivjLabelVertical.setText("Ver");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLabelVertical;
    }

    public Dimension getPageDimension() {
        if (this.fPageDimension == null) {
            this.fPageDimension = new Dimension(60, 40);
        }
        return this.fPageDimension;
    }

    private EditableNumericSpinner getPagesHorizontal() {
        if (this.ivjPagesHorizontal == null) {
            try {
                this.ivjPagesHorizontal = new EditableNumericSpinner();
                this.ivjPagesHorizontal.setName("PagesHorizontal");
                this.ivjPagesHorizontal.addNumericSpinnerListener(this);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjPagesHorizontal;
    }

    private JPanel getPagesPanel() {
        if (this.ivjPagesPanel == null) {
            try {
                this.ivjPagesPanel = new JPanel();
                this.ivjPagesPanel.setName("PagesPanel");
                this.ivjPagesPanel.setLayout(null);
                this.ivjPagesPanel.setBackground(Global.BACKGROUND_COLOR_APP);
                this.ivjPagesPanel.setBorder(null);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjPagesPanel;
    }

    private EditableNumericSpinner getPagesVertical() {
        if (this.ivjPagesVertical == null) {
            try {
                this.ivjPagesVertical = new EditableNumericSpinner();
                this.ivjPagesVertical.setName("PagesVertical");
                this.ivjPagesVertical.addNumericSpinnerListener(this);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjPagesVertical;
    }

    public Dimension getPreferredSize() {
        return new Dimension(340, 340);
    }

    private JPanel getPreviewBackgroundPanel() {
        if (this.ivjPreviewBackgroundPanel == null) {
            try {
                this.ivjPreviewBackgroundPanel = new JPanel();
                this.ivjPreviewBackgroundPanel.setName("PreviewBackgroundPanel");
                this.ivjPreviewBackgroundPanel.setBorder(new LineBorder(Color.black));
                this.ivjPreviewBackgroundPanel.setLayout(new GridBagLayout());
                GridBagConstraints constraintsPagesPanel = new GridBagConstraints();
                constraintsPagesPanel.gridx = 0;
                constraintsPagesPanel.gridy = 0;
                constraintsPagesPanel.weightx = 1.0;
                constraintsPagesPanel.weighty = 1.0;
                constraintsPagesPanel.fill = 2;
                constraintsPagesPanel.anchor = 10;
                constraintsPagesPanel.insets = new Insets(5, 5, 5, 5);
                this.getPreviewBackgroundPanel().add((Component)this.getPagesPanel(), constraintsPagesPanel);
                this.ivjPreviewBackgroundPanel.setBackground(Global.BACKGROUND_COLOR_APP);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjPreviewBackgroundPanel;
    }

    private BorderJPanel getPreviewPanel() {
        if (this.ivjPreviewPanel == null) {
            try {
                this.ivjPreviewPanel = new BorderJPanel();
                this.ivjPreviewPanel.setName("PreviewPanel");
                this.ivjPreviewPanel.setLayout(new BorderLayout());
                this.getPreviewPanel().add((Component)this.getPreviewBackgroundPanel(), "Center");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjPreviewPanel;
    }

    public String getTitle() {
        return Language.getString("action.drawingDimension", "Pages");
    }

    private void handleException(Throwable exception) {
    }

    private void initialize() {
        try {
            this.setName("DrawingDimensionPanel");
            this.setLayout(new GridBagLayout());
            this.setSize(382, 248);
            GridBagConstraints constraintsLabelHorizontal = new GridBagConstraints();
            constraintsLabelHorizontal.gridx = 0;
            constraintsLabelHorizontal.gridy = 0;
            constraintsLabelHorizontal.anchor = 17;
            constraintsLabelHorizontal.insets = new Insets(14, 10, 6, 10);
            this.add((Component)this.getLabelHorizontal(), constraintsLabelHorizontal);
            GridBagConstraints constraintsLabelVertical = new GridBagConstraints();
            constraintsLabelVertical.gridx = 0;
            constraintsLabelVertical.gridy = 1;
            constraintsLabelVertical.anchor = 17;
            constraintsLabelVertical.insets = new Insets(7, 10, 7, 10);
            this.add((Component)this.getLabelVertical(), constraintsLabelVertical);
            GridBagConstraints constraintsPagesHorizontal = new GridBagConstraints();
            constraintsPagesHorizontal.gridx = 1;
            constraintsPagesHorizontal.gridy = 0;
            constraintsPagesHorizontal.anchor = 17;
            constraintsPagesHorizontal.insets = new Insets(17, 0, 6, 0);
            this.add((Component)this.getPagesHorizontal(), constraintsPagesHorizontal);
            GridBagConstraints constraintsPagesVertical = new GridBagConstraints();
            constraintsPagesVertical.gridx = 1;
            constraintsPagesVertical.gridy = 1;
            constraintsPagesVertical.anchor = 17;
            constraintsPagesVertical.insets = new Insets(7, 0, 7, 0);
            this.add((Component)this.getPagesVertical(), constraintsPagesVertical);
            GridBagConstraints constraintsPreviewPanel = new GridBagConstraints();
            constraintsPreviewPanel.gridx = 0;
            constraintsPreviewPanel.gridy = 3;
            constraintsPreviewPanel.gridwidth = 2;
            constraintsPreviewPanel.fill = 1;
            constraintsPreviewPanel.weightx = 1.0;
            constraintsPreviewPanel.weighty = 1.0;
            constraintsPreviewPanel.insets = new Insets(8, 6, 8, 7);
            this.add((Component)this.getPreviewPanel(), constraintsPreviewPanel);
            GridBagConstraints constraintsDefault = new GridBagConstraints();
            constraintsDefault.gridx = 0;
            constraintsDefault.gridy = 2;
            constraintsDefault.gridwidth = 2;
            constraintsDefault.anchor = 17;
            constraintsDefault.insets = new Insets(4, 10, 4, 0);
            this.add((Component)this.getDefault(), constraintsDefault);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public void loadFieldContents() {
        EditableNumericSpinner field = this.getPagesHorizontal();
        field.setValue(this.fModel.getPagesHorizontal());
        field.setMin(1);
        field.setMax(100);
        field = this.getPagesVertical();
        field.setValue(this.fModel.getPagesVertical());
        field.setMin(1);
        field.setMax(100);
        this.spinnerChanged(null);
    }

    public static void main(String[] args) {
        try {
            JFrame frame = new JFrame();
            DrawingDimensionPanel aDrawingDimensionPanel = new DrawingDimensionPanel();
            frame.setContentPane(aDrawingDimensionPanel);
            frame.setSize(aDrawingDimensionPanel.getSize());
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            frame.show();
            Insets insets = frame.getInsets();
            frame.setSize(frame.getWidth() + insets.left + insets.right, frame.getHeight() + insets.top + insets.bottom);
            frame.setVisible(true);
        }
        catch (Throwable exception) {
            System.err.println("Exception occurred in main() of DE.siemens.ad.logo.dialog.comp.DataInputPanel");
            exception.printStackTrace(System.out);
        }
    }

    public void setLabels() {
        this.getLabelHorizontal().setText(Language.getString("dialog.drawingDimension.horizontal", "Horizontal"));
        this.getLabelVertical().setText(Language.getString("dialog.drawingDimension.vertical", "Vertical"));
        this.getDefault().setText(Language.getString("dialog.useAsDefault", "Use as default"));
        this.getPreviewPanel().setTitle(Language.getString("global.preview", "Preview"));
    }

    public void setPageDimension(Dimension newPageDimension) {
        this.fPageDimension = new Dimension((int)(newPageDimension.getWidth() * 0.05), (int)(newPageDimension.getHeight() * 0.05));
    }

    public void spinnerChanged(SpinnerChangedEvent se) {
        int hor = this.getPagesHorizontal().getValue();
        int ver = this.getPagesVertical().getValue();
        int nrOfPages = hor * ver;
        JPanel pagesPanel = this.getPagesPanel();
        if (this.fOldNrOfPages != nrOfPages) {
            pagesPanel.removeAll();
            if (this.checkFieldContents(false)) {
                Dimension pageDimension = this.getPageDimension();
                Dimension minPageDimension = new Dimension((int)(pageDimension.getWidth() * 0.8), (int)(pageDimension.getHeight() * 0.8));
                pagesPanel.setLayout(new GridLayout(ver, hor));
                this.getPreviewBackgroundPanel().setLayout(new GridBagLayout());
                for (int i = 0; i < nrOfPages; ++i) {
                    JPanel page = new JPanel();
                    page.setBorder(new LineBorder(Global.MARGIN_COLOR));
                    page.setBackground(Global.BACKGROUND_COLOR);
                    page.setPreferredSize(pageDimension);
                    page.setMinimumSize(minPageDimension);
                    page.setLayout(new BorderLayout());
                    page.add((Component)new JLabel(Integer.toString(i + 1), 0), "Center");
                    pagesPanel.add(page);
                }
            } else {
                pagesPanel.setLayout(new BorderLayout());
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.fill = 2;
                this.getPreviewBackgroundPanel().add((Component)pagesPanel, gbc);
                JTextArea label = new JTextArea(Language.getString("error.dialog.tooMuchPages", "For the total number of pages (horizontal x vertical)\nonly values from 1 to 100 are valid."));
                label.setEditable(false);
                label.setForeground(Color.red);
                label.setLineWrap(true);
                label.setWrapStyleWord(true);
                pagesPanel.add((Component)label, "Center");
            }
            pagesPanel.revalidate();
            pagesPanel.repaint();
            this.fOldNrOfPages = nrOfPages;
        }
    }

    public void storeFieldContents() {
        this.fModel.setPagesHorizontal(this.getPagesHorizontal().getValue());
        this.fModel.setPagesVertical(this.getPagesVertical().getValue());
        if (this.getDefault().isSelected()) {
            try {
                this.fModel.savePages();
            }
            catch (ProgramException e) {
                e.display((Window)this.getParent(), null);
            }
        }
        this.fDrawing.setModified(true);
    }
}

